# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdtypestruct import *
from .sdproperty import *
from .sdvalue import *
from .sdapiobject import *
from .sdproperty import *
from .sdproperty import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueStruct(SDValue):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueStruct
        """
        super(SDValueStruct, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(sdTypeStruct : SDTypeStruct) -> Optional[SDValueStruct]:
        """
        Create a new SDValueStruct from a SDTypeStruct

        :param sdTypeStruct: The SDTypeStruct to use to instantiate the SDValueStruct
        """
        outSDValueStruct = ctypes.c_void_p()
        _res = sd.getContext().SDValueStruct_sNew(sdTypeStruct.mHandle, ctypes.byref(outSDValueStruct))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueStruct, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueStruct.value, ownHandle=True)

    def getPropertyValue(self, sdProperty : SDProperty) -> Optional[SDValue]:
        """
        Get the value of the specified struct property

        :param sdProperty: The property we want to retrieve the value from
        """
        outSDValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDValueStruct_getPropertyValue(self.mHandle, sdProperty.mHandle, ctypes.byref(outSDValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDValue.value, ownHandle=True)

    def setPropertyValue(self, sdProperty : SDProperty, sdValue : SDValue) -> None:
        """
        Set the value of the specified struct property

        :param sdProperty: The property to change
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDValueStruct_setPropertyValue(self.mHandle, sdProperty.mHandle, sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    def getPropertyValueFromId(self, sdPropertyId : str) -> Optional[SDValue]:
        """
        Get the value of the specified property given its string identifier

        :param sdPropertyId: The identifier of the property to get the value from
        """
        outValue = ctypes.c_void_p()
        _res = self.mAPIContext.SDValueStruct_getPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outValue, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outValue.value, ownHandle=True)

    def setPropertyValueFromId(self, sdPropertyId : str, sdValue : SDValue) -> None:
        """
        Set the value of the specified struct property from its identifier

        :param sdPropertyId: The identifier of the property to set
        :param sdValue: The value to set
        """
        _res = self.mAPIContext.SDValueStruct_setPropertyValueFromId(self.mHandle, ctypes.create_string_buffer(sdPropertyId.encode('utf-8')), sdValue.mHandle)
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

